package nl.redrock.climbersapi;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/climbers")
public class ClimbersDataController {

    private final static Logger LOGGER = Logger.getLogger(ClimbersDataController.class.getName());

    @Autowired
    ClimberRepository climberRepository;
    
    @RequestMapping(method = RequestMethod.GET)
    List<Climber> getClimbers() {
        List<Climber> result;
        LOGGER.log(Level.INFO, "Getting all climbers");
        result = new ArrayList();
        Iterable<Climber> climberList = climberRepository.findAll();
        for (Climber climber : climberList) {
            result.add(climber);
        }
        return result;
    }
        
    @RequestMapping("/{id}")
    public Climber getClimber(@PathVariable int id) {
        Climber result;
        LOGGER.log(Level.INFO, "Getting climber with id " + id);
        result = climberRepository.findById(id);
        return result;
    }
  
    
    @RequestMapping(method = RequestMethod.POST)
    void saveClimber(@RequestBody Climber input) {
        LOGGER.log(Level.INFO, "Saving climber " + input.getLastname());
        Climber climber = new Climber();
        climber.setFirstname(input.getFirstname());
        climber.setLastname(input.getLastname());    
	climberRepository.save(climber);
    }
}
